<?php
session_start();
if (!isset($_SESSION['username'])) header("Location: user_login.php");
$username = $_SESSION['username'];
$role = $_SESSION['role'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Walkie-Talkie Meeting</title>
    <link rel="stylesheet" href="style.css">
    <script src="https://www.gstatic.com/firebasejs/8.10.1/firebase-app.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.10.1/firebase-firestore.js"></script>
</head>
<body>

    <div class="glass-card" style="width: 90%; max-width: 600px;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h3 id="status" style="color: #fff;">Status: <span id="conn-text" style="color: var(--gold);">Connecting...</span></h3>
            <h3 id="count" style="color: var(--gold);">Online: 0</h3>
        </div>

        <div id="user-list" style="margin: 20px 0; min-height: 150px;">
            </div>

        <?php if($role == 'user' || $role == 'admin'): ?>
            <div class="mic-container" style="text-align: center;">
                <button id="micBtn" class="mic-btn">🎙️</button>
                <p id="hint" style="color: #ccc; margin-top: 10px;">Press and Hold to Speak</p>
            </div>
        <?php endif; ?>

        <button onclick="location.href='logout.php'" class="btn-gold" style="background:#ff4444; color:white; margin-top:20px;">LEAVE MEETING</button>
    </div>

    <div id="remote-audios"></div>

    <script>
        const USERNAME = "<?php echo $username; ?>";
        const ROLE = "<?php echo $role; ?>";
    </script>
    <script src="firebase-config.js"></script>
    <script src="webrtc.js"></script>
</body>
</html>