<?php
session_start();
if ($_SESSION['role'] != 'admin') header("Location: user_login.php");

$jsonFile = 'users.json';

if (isset($_POST['add_user'])) {
    $users = json_decode(file_get_contents($jsonFile), true);
    $newUser = [
        "username" => $_POST['new_user'],
        "password" => password_hash($_POST['new_pass'], PASSWORD_DEFAULT),
        "role" => "user"
    ];
    $users[] = $newUser;
    file_put_contents($jsonFile, json_encode($users, JSON_PRETTY_PRINT));
}
$allUsers = json_decode(file_get_contents($jsonFile), true);
?>
<!DOCTYPE html>
<html>
<head><link rel="stylesheet" href="style.css"></head>
<body>
    <div class="glass-card">
        <h2>Admin Panel (JSON Mode)</h2>
        <form method="POST">
            <input type="text" name="new_user" placeholder="New Username" required>
            <input type="text" name="new_pass" placeholder="New Password" required>
            <button type="submit" name="add_user" class="btn-gold">ADD USER</button>
        </form>
        <h3>User List</h3>
        <div style="text-align:left;">
            <?php foreach($allUsers as $u) echo "<div class='user-row'>".$u['username']." (".$u['role'].")</div>"; ?>
        </div>
        <button onclick="location.href='meeting.php'" class="btn-gold" style="background:#28a745; margin-top:10px;">HOST MEETING</button>
    </div>
</body>
</html>